**** Ordinary Least Squares Regression ****.
REGRESSION
/DEPENDENT life.satisfaction
/METHOD=ENTER parental.love.

**** Ordinary Least Squares Regression with Moderation ****.
*First, you must create your interaction term.
COMPUTE c.bf.close = bf.close - 8.743073.
COMPUTE loveXclose = parental.love*c.bf.close.
EXECUTE.
*Then, run the full-factorial model.
REGRESSION
/DEPENDENT life.satisfaction
/METHOD=ENTER parental.love c.bf.close loveXclose.

**** Multilevel Modeling ****.

*2-Level Model with Random Intercept Only.
MIXED life.satisfaction WITH parental.love
 /FIXED= parental.love
/PRINT= SOLUTION
/RANDOM=INTERCEPT | SUBJECT( school.id ).

*2-Level Model with Random Intercept and Random Slope.
MIXED life.satisfaction WITH parental.love
 /FIXED= parental.love
/PRINT= SOLUTION
/RANDOM=INTERCEPT parental.love | SUBJECT( school.id ).

*2-Level Moderation with Random Intercept and a covariate.
MIXED life.satisfaction WITH school.type c.bf.close parental.love
/FIXED=school.type c.bf.close parental.love c.bf.close*parental.love
/RANDOM=INTERCEPT | SUBJECT(school.id)
/PRINT=SOLUTION.

**** Calculate Effect Size: Pseudo-R^2 ****.
*Baseline model.
MIXED life.satisfaction
/FIXED=INTERCEPT
/RANDOM=INTERCEPT | SUBJECT(school.id)
/PRINT=SOLUTION.


**** 1-1-1 Multilevel Mediation ****.

*First, you need to create your level 2 aggregate variables for sex and parental.monitoring.
AGGREGATE
/OUTFILE=* MODE=ADDVARIABLES
/BREAK=school.id
/sex.agg=MEAN(sex)
/parental.monitoring.agg=MEAN(parental.monitoring).

*Next, use this variable to group-mean center level 1 sex and parental.monitoring.
COMPUTE sex.cwc = sex - sex.agg.
COMPUTE parental.monitoring.cwc = parental.monitoring - parental.monitoring.agg.
EXECUTE.

*Finally, grand-mean center the aggregated variables.
*First you need to find the means of the aggregated variables.
DESCRIPTIVES
/VAR=sex.agg parental.monitoring.agg.
*Plug those means into compute to center the aggregated variables.
COMPUTE sex.agg.c = sex.agg - .0238.
COMPUTE parental.monitoring.agg.c = parental.monitoring.agg - 8.7320.
EXECUTE.

*1-1-1 Mediation: Causal Steps!.
MIXED sexual.age WITH sex.agg.c sex.cwc
 /FIXED= sex.agg.c sex.cwc
/PRINT= SOLUTION
/RANDOM=INTERCEPT | SUBJECT( school.id ).

MIXED parental.monitoring WITH sex.agg.c sex.cwc
 /FIXED= sex.agg.c sex.cwc
/PRINT= SOLUTION
/RANDOM=INTERCEPT | SUBJECT( school.id ).

MIXED sexual.age WITH sex.agg.c sex.cwc parental.monitoring.agg.c parental.monitoring.cwc
 /FIXED= sex.agg.c sex.cwc parental.monitoring.agg.c parental.monitoring.cwc
/PRINT= SOLUTION
/RANDOM=INTERCEPT | SUBJECT( school.id ).